#====================
#dataset
import matplotlib.pyplot as plt
import pandas as pd
import numpy as np


# Changing the DPI of an image
plt.rcParams['savefig.dpi']=400

# #===========================================================
# #===========================================================
#Obtain data from Excel file
path1='Planilla_pruebas.xlsx'

Data_df = pd.read_excel(path1) 

#Change format to numpy
Data=Data_df.to_numpy()

XX = Data[3:22,:] 
XY = Data[23:30,:]
XZ = Data[31:,:]

Data = np.concatenate((XX,XY,XZ),axis=0)

#Input variables
X = Data[:,1:6]
#output variable
y = Data[:,6]



# #===========================================================
#===========================================================
# histograms per input variable variang from X[:,0] -> X[:,4]
# [0,1,2,4,8]
# plt.hist(X[:,4], bins='auto', alpha=.3, color ="blue", edgecolor='blue')

#histogram for output variable
plt.hist(y, bins=13, alpha=.3, color ="blue", edgecolor='blue')

# plt.title("SCWI") 
# plt.title("DSB") 
# plt.title("TMT") 
# plt.title("Age") 
# plt.title("Educational level") 
# plt.xlabel("MBT test result")
plt.ylabel("Frequency", fontsize=15)
# plt.grid(True)
plt.grid(axis='y', alpha=0.75)
plt.xticks(fontsize=15)
plt.yticks(fontsize=15)
# plt.show()

# plt.savefig('Plot1.jpg')



